<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Garage extends Model 
{

    protected $table = 'garages';
    public $timestamps = true;
    protected $fillable = array('id', 'name_ar', 'name_en', 'description_ar', 'description_en', 'record_number', 'logo', 'active', 'availablity', 'country_id');

    public function contact()
    {
        return $this->morphOne('App\Models\Contact', 'contactable');
    }

    public function favourites()
    {
        return $this->morphToMany('App\Models\User', 'favouriable');
    }

    public function reviews()
    {
        return $this->morphToMany('App\Models\User', 'reviewable');
    }

    public function categories()
    {
        return $this->morphToMany('App\Models\Category', 'categorizable');
    }

    public function work_time()
    {
        return $this->morphOne('App\Models\WorkTime', 'workable');
    }

    public function services()
    {
        return $this->morphMany('App\Models\Service', 'servable');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

    public function products()
    {
        return $this->morphMany('App\Models\Product', 'productable');
    }

}